/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Scheduler.c
\brief      Multi-Thread Scheduler to manage Pwm sample application
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/20/2008
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
  
  #include "Scheduler.h"

  /* -- Global Variables --------------------------------------------------------*/
  uint8_t gu8Scheduler_Ctrl;
  uint8_t gu8Scheduler_Flag;
 /* Global Sleep Mode enable flag */
  uint8_t gu8SleepModeEnabled;

/****************************************************************************************************/
/**
* \brief    Initialise Scheduler Timebase using eMios Channel 0 as a tick reference. 
* \author   R01160
* \param    void
* \return   void
* \warning  Modifying emios channel 0 settings will change Scheduler timebase.
*/
void vfnScheduler_Init(void)
{
   vfnPit_Init(SCHEDULER_CHANNEL, SCHEDULER_LOOP_TIME);  /* Initialize PIT channel x */
}

/****************************************************************************************************/
/**
* \brief    Start the operation of Specific Emios channel using the Modulus Up Counter.
* \author   R01160
* \param    void
* \return   void
* \todo     
*/
void vfnStart_Scheduler(void)
{    
   PIT_ENABLED(SCHEDULER_CHANNEL);  /* Start PIT x channel to count down */
}


/*------ INTERRUPTS ------------------------------------------------------------------------------*/
void Scheduler_Fnc_Handler(void)
{    
    /*-- Update scheduler control variables --*/
    gu8Scheduler_Ctrl++;        
        
      if ((gu8Scheduler_Ctrl & (uint8_t)0x01) == (uint8_t)0x01)
      {  
          /*-- Allow 100 ms periodic tasks to be executed --*/
          gu8Scheduler_Flag = (uint8_t)0x01;
      }
      else
      { 
            if ((gu8Scheduler_Ctrl & (uint8_t)0x02) == (uint8_t)0x02)
            {    
                /*-- Allow 200 ms periodic tasks to be executed --*/
                gu8Scheduler_Flag = (uint8_t)0x02;
            }
            else
            { 
                if ((gu8Scheduler_Ctrl & (uint8_t)0x04) == (uint8_t)0x04)
                {
                    /*-- Allow 400 ms periodic tasks to be executed --*/
                    gu8Scheduler_Flag = (uint8_t)0x04;
                }
                else
                {     
                    if ((gu8Scheduler_Ctrl & (uint8_t)0x08) == (uint8_t)0x08)
                    {
                        /*-- Allow 800 ms group A periodic tasks to be executed --*/
                        gu8Scheduler_Flag = (uint8_t)0x08;
                    }
                    else
                    {     
                        if ((gu8Scheduler_Ctrl & (uint8_t)0x0F) == (uint8_t)0x00)
                        {
                            /*-- Allow 800 ms group B periodic tasks to be executed --*/
                            gu8Scheduler_Flag = (uint8_t)0x10;
                        }
                    }
                }
            }
      }        
}
